/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.objmgr.console;

import com.ibm.hsc.common.util.HardwareServerMessage;
import com.ibm.hsc.fsp.FspConnListener;
import com.ibm.hsc.fsp.HWSvrSocket;
import com.ibm.hsc.fsp.cmdhelpers.FspQueryData;
import com.ibm.hsc.objmgr.console.OmConnCreationThread;
import com.ibm.hsc.objmgr.console.OmConsoleMgr;
import java.util.Hashtable;
import java.util.Vector;
import org.snia.wbem.cim.UnsignedInt16;

public class OmConnListener
extends Thread
implements FspConnListener {
    private Hashtable mRunningReqs = new Hashtable();
    private Vector mNewConns = new Vector();
    private boolean mIsWaiting = false;
    private OmConsoleMgr mConsoleMgr = null;
    private HWSvrSocket mHwSvrSocket = null;

    OmConnListener(OmConsoleMgr omConsoleMgr) {
        this.mConsoleMgr = omConsoleMgr;
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void foundNewVport(HardwareServerMessage hardwareServerMessage) {
        OmConnListener omConnListener = this;
        synchronized (omConnListener) {
            this.mNewConns.addElement(hardwareServerMessage);
            if (this.mIsWaiting) {
                this.notify();
            }
        }
    }

    public synchronized HardwareServerMessage getNextHwmsg() {
        while (this.mNewConns.size() <= 0) {
            this.mIsWaiting = true;
            try {
                this.wait();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.mIsWaiting = false;
            System.out.println("wakeup from wait");
        }
        return (HardwareServerMessage)this.mNewConns.remove(0);
    }

    public void run() {
        while (true) {
            HardwareServerMessage hardwareServerMessage = this.getNextHwmsg();
            this.procMessage(hardwareServerMessage);
        }
    }

    private void procMessage(HardwareServerMessage hardwareServerMessage) {
        int n = hardwareServerMessage.getVirtualPort();
        long l = System.currentTimeMillis();
        try {
            FspQueryData fspQueryData = new FspQueryData(hardwareServerMessage);
            fspQueryData.setChangeTime(l);
            this.procMessage(fspQueryData, n);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private void procMessage(FspQueryData fspQueryData, int n) {
        boolean bl = false;
        try {
            UnsignedInt16 unsignedInt16 = fspQueryData.getInterfaceVersionFamily();
            UnsignedInt16 unsignedInt162 = fspQueryData.getFspType();
            String string = fspQueryData.getMtms();
            System.out.println("mtms: " + string);
            Integer n2 = new Integer(n);
            OmConnCreationThread omConnCreationThread = (OmConnCreationThread)this.mRunningReqs.get(n2);
            System.out.println("creationThread " + omConnCreationThread);
            if (omConnCreationThread == null) {
                omConnCreationThread = new OmConnCreationThread(fspQueryData, n, this);
                this.mRunningReqs.put(n2, omConnCreationThread);
                omConnCreationThread.start();
            } else {
                omConnCreationThread.addNewReq(fspQueryData);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void finishHandling(int n) {
        this.mRunningReqs.remove(new Integer(n));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hardwareServerDisconnected() {
        Object object = this;
        synchronized (object) {
            this.mNewConns.clear();
        }
        object = this.mRunningReqs.elements();
        while (object.hasMoreElements()) {
            OmConnCreationThread omConnCreationThread = (OmConnCreationThread)object.nextElement();
            omConnCreationThread.addNewReq(null);
        }
        this.mRunningReqs.clear();
    }

    public void hardwareServerConnected() {
        this.mConsoleMgr.reconnect();
    }
}

